%i "creg00.h"
module NAME {
/* nagami
** 1996/08/15 17:59:44
** 1.1
** Exp */
/**********************************++**********************************/
/*  Access Interface                                                  */
/**********************************++**********************************/
    %d PCI_CORE instrout
    %d CORE_PCI instrin
    %i "iaccess.pin"

/**********************************++**********************************/
/*  PCI interface                                                     */
/**********************************++**********************************/
    /* System pins */
    input nRST;

    /* Address and data pins */
    bidirect AD<32>; instrout ADenb;
    bidirect nC_BE<4>; instrout C_BEenb;
    bidirect PAR; instrout PARenb;

    /* Interface control pins */
    input nFRAMEin; output nFRAMEout; instrout FRAMEenb;
    input nIRDYin; output nIRDYout; instrout IRDYenb;
    input nTRDYin; output nTRDYout; instrout TRDYenb;
    input nSTOPin; output nSTOPout; instrout STOPenb;
    instrin IDSEL;
    input nDEVSELin; output nDEVSELout; instrout DEVSELenb;
    output nREQ;
    input nGNT;
    input nPERRin; output nPERRout; instrout PERRenb;
    instrout SERRenb;

/**********************************++**********************************/
/*  Originally Added                                                  */
/**********************************++**********************************/
    creg00 CR;
    
    instrself req; /* for REQ# */
    
    instrself iinvoke;
    instrself itask;
    instrself iactive;

    instrself nextAddr;
    instrself comMR;  /* Memory Read Command */
    instrself comMRL; /* Memory Read Line Command */
    instrself comMW;  /* Memory Write Command */
    instrself comIOR; /* I/O Read Command */
    instrself comIOW; /* I/O Write Command */
    instrself comCR;  /* Configuration Read Command */
    instrself comCW;  /* Configuration Write Command */
    instrself tactive;

    instrself readReqDone; sel data<32>;
    instrself writeReqDone;
    instrself reqBusy;

    reg PARR<1>;

    reg IAR<32>;
    reg IBER<4>;
    reg IDR<32>;
    reg CNT<8>;

    reg TAR<32>;
    reg TCR<4>;
    reg TIDSELR;
    reg TDR<32>;

    reg WAIT; /* working register */

/**********************************++**********************************/
/*  Instruct Arguments                                                */
/**********************************++**********************************/
    %i "iaccess.pca"

    instr_arg ADenb(AD);
    instr_arg C_BEenb(nC_BE);
    instr_arg PARenb(PAR);
    instr_arg FRAMEenb(nFRAMEout);
    instr_arg IRDYenb(nIRDYout);
    instr_arg TRDYenb(nTRDYout);
    instr_arg STOPenb(nSTOPout);
    instr_arg DEVSELenb(nDEVSELout);
    instr_arg PERRenb(nPERRout);
    instr_arg SERRenb();

    instr_arg readReqDone(data);
    instr_arg writeReqDone();
    instr_arg reqBusy();

/**********************************++**********************************/
/*  Stage Declarations                                                */
/**********************************++**********************************/
    stage_name Parity { task gen(PARR); }
    stage_name SuperVisor { task run(); }
    stage_name Initiator {
	task tReadMem    (IAR, IBER,      CNT);
	task tReadMemLine(IAR, IBER,      CNT);
	task tWriteMem   (IAR, IBER, IDR, CNT);
	task tReadIO     (IAR, IBER,      CNT);
	task tWriteIO    (IAR, IBER, IDR, CNT);
	task tReadConfig (IAR, IBER,      CNT);
	task tWriteConfig(IAR, IBER, IDR, CNT);
    }
    stage_name Target { task tAction(TAR, TCR, TIDSELR); }

/**********************************++**********************************/
/*  Instantaneous Actions                                             */
/**********************************++**********************************/
    par {
	if (^nRST & ^SuperVisor.run)
	    generate SuperVisor.run();

	nREQ = ^req;

	/* Parity Generation */
	if ( ADenb & ^Parity.gen)
	    generate Parity.gen(/@(AD||nC_BE));

	/* Bus Parking */
	if (^nGNT & nFRAMEin & nIRDYin & ^iactive) par {
	    ADenb(0xffffffff);
	    C_BEenb(0b1111);
	}
    }

/**********************************++**********************************/
/*  iAccess Master Actions                                            */
/**********************************++**********************************/
/**********************************++**********************************/
/*  Common Stages                                                     */
/**********************************++**********************************/
    stage SuperVisor {
	state_name reset;
	state_name polling;
	first_state reset;

	state reset par { CR.reset(); Reset(); WAIT := 0b0; goto polling; }
	state polling par {
	    if (^nRST) goto reset;
	    if ( nRST) par {
		if (^iactive & ^tactive) par {
		    if ( (^nFRAMEin &  nDEVSELin))
			generate Target.tAction(AD, nC_BE, IDSEL);
		    if (^(^nFRAMEin &  nDEVSELin)) par {
			if (CR.command<2>) /* command Bit 2: Bus Master */ par {
			    Ready();
			    if ( ReadMem)
				generate Initiator.tReadMem(
				    Adr<31:2>||0b00, /* Linear increment */
				    ^Be, 0x01);
			    if ( ReadMemLine)
				generate Initiator.tReadMemLine(
				    Adr<31:2>||0b01, /* Cache Line Wrap Mode */
				    ^Be, 0x04);
			    if ( WriteMem)
				generate Initiator.tWriteMem(
				    Adr<31:2>||0b00, /* Linear increment */
				    ^Be, /* Note that BE# is negative. */
				    Data, 0x01);
			    if ( ReadIO)  generate Initiator.tReadIO (Adr, ^Be,       0x01);
			    if ( WriteIO) generate Initiator.tWriteIO(Adr, ^Be, Data, 0x01);
			    if ( ReadConfig)
				generate Initiator.tReadConfig(
				    (/(Adr<15:11>))<20:0>||Adr<10:0>,
				    ^Be,       0x01);
			    if ( WriteConfig)
				generate Initiator.tWriteConfig(
				    (/(Adr<15:11>))<20:0>||Adr<10:0>,
				    ^Be, Data, 0x01);
			}
		    }
		}
	    }
	}
    }

    stage Parity {
	par {
	    PARenb(PARR);
	    any {
		(^ADenb): finish;
		( ADenb): PARR := /@(AD||nC_BE);
	    }
	}
    }

/**********************************++**********************************/
/*  Initiater Stages                                                  */
/**********************************++**********************************/
    stage Initiator {
	state_name arbit;
	state_name stepPhase;
	state_name addrPhase;
	state_name dataPhase;
	state_name turnAround;
	state_name park;
	first_state arbit;

	par { iactive(); }

	state arbit par {
	    if (^nRST) par { goto arbit; finish; }
	    if ( nRST) par {
		req(); /* Assert REQ# via req() */
		if (^nGNT & nFRAMEin & nIRDYin) any {
		    ( Initiator.tReadConfig ): goto stepPhase;
		    ( Initiator.tWriteConfig): goto stepPhase;
		    else: goto addrPhase;
		}
	    }
	}

	state stepPhase par {
	    if (^nRST) par { goto arbit; finish; }
	    if ( nRST) par {
		/* FRAMEenb(0b0); */ /* *DON'T* Assert FRAME# */
		ADenb(IAR);	   /* Drive AD as Address */
		goto addrPhase;
	    }
	} /* state addrStepPhase */
	
	state addrPhase par {
	    if (^nRST) par { goto arbit; finish; }
	    if ( nRST) par {
		FRAMEenb(0b0); /* Assert FRAME# */
		ADenb(IAR);    /* Drive AD    as Address */
		any {          /* Drive C/BE# as bus command */
		    ( Initiator.tReadMem)    : C_BEenb(0b0110);
		    ( Initiator.tReadMemLine): C_BEenb(0b1110);
		    ( Initiator.tWriteMem)   : C_BEenb(0b0111);
		    ( Initiator.tReadIO)     : C_BEenb(0b0010);
		    ( Initiator.tWriteIO)    : C_BEenb(0b0011);
		    ( Initiator.tReadConfig) : C_BEenb(0b1010);
		    ( Initiator.tWriteConfig): C_BEenb(0b1011);
		}
		goto dataPhase;
	    }
	} /* state addrPhase */

	state dataPhase par {
	    if (^nRST) par { goto arbit; finish; }
	    if ( nRST) par {
		if (^nIRDYin & ^nTRDYin) par { /* Data Transfer   */
		    CNT := CNT + 0xff; /* --CNT        */
		    any {
			( Initiator.tReadMem)    : ReadDone(AD);
			( Initiator.tReadMemLine): ReadDone(AD);
			( Initiator.tWriteMem)   : WriteDone();
			( Initiator.tReadIO)     : ReadDone(AD);
			( Initiator.tWriteIO)    : WriteDone();
			( Initiator.tReadConfig) : ReadDone(AD);
			( Initiator.tWriteConfig): WriteDone();
		    }
		    if ( nFRAMEin) goto turnAround;
		}
		any { /* For FRAME # */
		    (^(CNT==0x01)): FRAMEenb(0b0); /* Assert FRAME# */
		    ( (CNT==0x01)): FRAMEenb(0b1); /* Deassert FRAME# */
		}
		any { /* For AD */
		    ( Initiator.tWriteMem)   : ADenb(IDR); /* mem. write     */
		    ( Initiator.tWriteIO)    : ADenb(IDR); /* I/O. write     */
		    ( Initiator.tWriteConfig): ADenb(IDR); /* config. write     */
		}
		C_BEenb(IBER); /* Drive C/BE# */
		IRDYenb(0b0); /* Assert IRDY#    */
	    }
	} /* state dataPhase */

	state turnAround par {
	    if (^nRST) par { goto arbit; finish; }
	    if ( nRST) par {
		IRDYenb(0b1); /* Deassert IRDY# */
		goto arbit;
		finish;
	    }
	} /* state turnAround */
    } /* stage Initiator */

/**********************************++**********************************/
/*  Target Stages                                                     */
/**********************************++**********************************/
    stage Target {
	state_name decode;
	state_name access;
	state_name reqWait;
	state_name irdyWait;
	first_state decode;

	if ( nRST) par {
	    tactive();
	    any { /* Decode Bus Command */
		(TCR==0b0110): comMR();
		(TCR==0b1110): comMRL();
		(TCR==0b0111): comMW();
		(TCR==0b0010): comIOR();
		(TCR==0b0011): comIOW();
		(TCR==0b1010): comCR();
		(TCR==0b1011): comCW();
	    }
	    if ( nextAddr) par {
		if (comMR | comMRL | comMW) any {
		    (TAR<1:0> == 0b00) /* Linear Increment */:
			TAR := (TAR<31:2>+0b1)||TAR<1:0>;
		    (TAR<1:0> == 0b01) /* Cache Line Wrap Mode */:
			/* Line size is Assumed to be 4. */
			TAR := TAR<31:4>||(TAR<3:2>+0b1)||TAR<1:0>;
		}
		if (comIOR | comIOW) ;
		if (comCR | comCW) ;
	    }
	}

	state decode par {
	    if (^nRST) par { goto decode; finish; }
	    if ( nRST) par {
		if (comMR | comMRL | comMW) par {
		    if (^CR.command<1>) /* command Bit 1: Memory Space */ finish;
		    if ( CR.command<1>) par {
			CR.decodeMemAdr(TAR);
			any {
			    ( CR.adrHit) /* It's me! */: par {
				TAR := CR.devAdr;
				DEVSELenb(0b0); /* Assert DEVSEL# */
				goto access;
			    }
			    (^CR.adrHit): finish;
			}
		    }
		}
		if  (comIOR | comIOW) par {
		    if (^CR.command<0>) /* command Bit 0: I/O Space */ finish;
		    if ( CR.command<0>) par {
			CR.decodeIOAdr(TAR);
			any {
			    ( CR.adrHit) /* It's me! */: par {
				TAR := CR.devAdr;
				DEVSELenb(0b0); /* Assert DEVSEL# */
				goto access;
			    }
			    (^CR.adrHit): finish;
			}
		    }
		}
		if  (comCR | comCW) any {
		    ( TIDSELR) /* It's me! */: par {
			DEVSELenb(0b0); /* Assert DEVSEL# */
			goto access;
		    }
		    else: finish;
		}
	    }
	}
	
	state access par {
	    if (^nRST) par { goto decode; finish; }
	    if ( nRST) par {
		DEVSELenb(0b0); /* Assert DEVSEL# */
		
		if (comMR)  ReadMemReq (TAR<31:2>||0b00, ^nC_BE);
		if (comMRL) ReadMemReq (TAR,             ^nC_BE);
		if (comMW)  WriteMemReq(TAR,             ^nC_BE, AD);
		if (comIOR) ReadIOReq  (TAR,             ^nC_BE);
		if (comIOW) WriteIOReq (TAR,             ^nC_BE, AD);
		if (comMR | comMRL | comIOR) par {
		    reqBusy();
		    if ( ReadReqDone)  readReqDone(Data);
		    if (^ReadReqDone)  par { TRDYenb(0b1); goto reqWait; }
		}
		if (comMW | comIOW) par {
		    reqBusy();
		    if ( WriteReqDone) writeReqDone();
		    if (^WriteReqDone) par { TRDYenb(0b1); goto reqWait; }
		}
		
		if (comCR) readReqDone(CR.read(TAR<7:2>, ^nC_BE).data);
		if (comCW) par {
		    CR.write(TAR<7:2>, ^nC_BE, AD);
		    writeReqDone();
		}

		if (readReqDone | writeReqDone) par {
		    TRDYenb(0b0);
		    if (readReqDone) par { ADenb(data); TDR := data; }
		    if ( nIRDYin) /* Initiator is busy ! */ goto irdyWait;
		    if (^nIRDYin) par { /* Data Transfered ! */
			nextAddr();
			if ( nFRAMEin) /* The Last Data ! */ par { goto decode; finish; }
		    }
		}
	    }
	} /* state access */

	state reqWait par {
	    if (^nRST) par { goto decode; finish; }
	    if ( nRST) par {
		DEVSELenb(0b0);
		reqBusy();
		if (ReadReqDone | WriteReqDone) par {
		    TRDYenb(0b0);
		    if (ReadReqDone) ADenb(Data);
		    
		    if ( nIRDYin) par { TDR := Data; goto irdyWait; }
		    if (^nIRDYin) par {
			nextAddr();
			if (^nFRAMEin) goto access;
			if ( nFRAMEin) par { goto decode; finish; }
		    }
		}
	    }
	} /* state reqWait */

	state irdyWait par {
	    if (^nRST) par { goto decode; finish; }
	    if ( nRST) par {
		DEVSELenb(0b0);
		TRDYenb(0b0);
		if (comMR)  ADenb(TDR);
		if (comMRL) ADenb(TDR);
		if (comIOR) ADenb(TDR);
		if (comCR)  ADenb(TDR);
		
		if ( nIRDYin) /* Stay Here */;
		if (^nIRDYin) par {
		    nextAddr();
		    if (^nFRAMEin) goto access;
		    if ( nFRAMEin) par { goto decode; finish; }
		}
	    }
	} /* state irdyWait */
    } /* stage Target */
}
