# fact.asm --- calculate 10!(factorial) with recursive func. call.
# by K.Nagami

# These 4 lines are only for the definition of memory map.
        .data 0x00000000 = " "[0]
sys:    .space 0
        .data 0x08000000 = " "[0]
user:   .space 0
        .data 0xffff0000 = " "[0]
io:     .space 0

#--- I/O port ---
        .data io + 0x0000ff00 = " "[0]
        .align 0
IOcnt:  .space 0                        # valid I/O port area
Ccnt:   .space 0                        # clock counter port
        .space 4
Rcnt:   .space 0                        # read access counter port
        .space 4
Wcnt:   .space 0                        # write access counter port
        .space 4
RWcnt:  .space 0                        # access counter port
        .space 4

#--- Boot Segment - Execution starts here. ---
        .text sys = "/SYS/M00"[0]

        lhi $a0, (USR_CF >> 16)         #
        . $a0 |= (USR_CF & 0xffff)      # $a0 = USR_CF
        . call @config                  # configuration
        . nop                           # slot

        lhi $a0, (CPU_CF >> 16)         #
        . $a0 |= (CPU_CF & 0xffff)      # $a0 = CPU_CF
        . call @config                  # configuration
        . nop                           # slot

        lhi $t9, (@program >> 16)       #
        . $t9 |= (@program & 0xffff)    # $t9 = @program
        . goto $t9                      # goto @program
        . nop                           # slot


@config:
        # $a0: start address of configuration data.
        lhi $t9, (io >> 16)
        . $t9 |= (io & 0xffff)          # $t9 = io
        . $t8 = $0 - 1                  # $t8 = 0xffffffff
@loop:  
        . $t0 = (%w)$a0[0x0]            # CONFIG_ADDRESS
        . $t1 = (%w)$a0[0x4]            # Write Data
        . $t2 = (%w)$a0[0x8]            # Write Mask
        . $t3 = (%w)$a0[0xc]            # End mark

        . $t9[0x0cf8] = $t0             # write to CONFIG_ADDRESS
        . $t4 = (%w)$t9[0x0cfc]         # read register value
        . $t1 &= $t2                    # mask write data
        . $t2 ^= $t8                    # negate $t2
        . $t4 &= $t2                    # mask read data
        . $t1 |= $t4                    # merge write data and read data
        . $t9[0x0cfc] = $t1             # write the value to register

        bnez $t3, @loop                 # loop back if continued
        . $a0 [+]= (@@C_END - @@C_ORG)  # valid slot (next entry)
        . return                        # else return
        . nop                           # slot

#--- Configuration Data ---
        .data sys + 0x10000 = "/SYS/M00"[0x10000]
        # For USR Memory Configuration
USR_CF: .space 0
@@C_ORG:.space 0
        #     enable  .......   bus#   dev.#  func.# reg.#
        .word (1<<31)|(0<<24)|(0<<16)|(1<<11)|(0<<8)|(0x04) # [status] [command]
        #                         +- fast back-to-back enable
        #                         |+- SERR# enable
        #                         ||+- wait cycle control
        #                         |||+- parity error response
        #                         ||||+- VGA palette snoop
        #                         |||||+- memory write and invalidate enable
        #                         ||||||+- special cycles
        #                         |||||||+- bus master
        #                         ||||||||+- memory space
        #       status      ......|||||||||+- I/O space
        .half 0x00000000, 0b0000000000000011 # value
        .half 0xffffffff, 0b0000001111111111 # mask
        .word 1 # continue
@@C_END:.space 0

        #     enable  .......   bus#   dev.#  func.# reg.#
        .word (1<<31)|(0<<24)|(0<<16)|(1<<11)|(0<<8)|(0x0c) # [] [] [] [cache line size]
        #                       size
        .byte 0x00, 0x00, 0x00, 0x04 # value
        .byte 0x00, 0x00, 0x00, 0xff # mask
        .word 1 # continue

        #     enable  .......   bus#   dev.#  func.# reg.#
        .word (1<<31)|(0<<24)|(0<<16)|(1<<11)|(0<<8)|(0x10) # [I/O base address]
        .word 0x0000ff00 # value
        .word 0xffffffff # mask
        .word 1 # continue

        #     enable  .......   bus#   dev.#  func.# reg.#
        .word (1<<31)|(0<<24)|(0<<16)|(1<<11)|(0<<8)|(0x14) # [Mem. base address]
        .word 0x08000000 # value
        .word 0xffffffff # mask
        .word 0 # end

        # For DLX CPU Configuration
CPU_CF: .space 0
        #     enable  .......   bus#   dev.#  func.# reg.#
        .word (1<<31)|(0<<24)|(0<<16)|(0<<11)|(0<<8)|(0x04) # [status] [command]
        #                         +- fast back-to-back enable
        #                         |+- SERR# enable
        #                         ||+- wait cycle control
        #                         |||+- parity error response
        #                         ||||+- VGA palette snoop
        #                         |||||+- memory write and invalidate enable
        #                         ||||||+- special cycles
        #                         |||||||+- bus master
        #                         ||||||||+- memory space
        #       status      ......|||||||||+- I/O space
        .half 0x00000000, 0b0000000101000100 # value
        .half 0x11111111, 0b0000001111111111 # mask
        .word 1 # continue

        #     enable  .......   bus#   dev.#  func.# reg.#
        .word (1<<31)|(0<<24)|(0<<16)|(0<<11)|(0<<8)|(0x0c) # [] [] [] [cache line size]
        #                       size
        .byte 0x00, 0x00, 0x00, 0x04 # value
        .byte 0x00, 0x00, 0x00, 0xff # mask
        .word 0 # end

#--- User Program ---
        #--- code ---
        .text user + 0 = "/USR/M00"[0]
@program:
        lhi $t9, (IOcnt >>16)           #
        . $t9 |= (IOcnt & 0xffff)       # $t9 = IOcnt

        lhi $gp, (DATA >> 16)           #
        . $gp |= (DATA & 0xffff)        # $gp = DATA

        lhi $sp, (ends >> 16)           #
        . $sp |= (ends & 0xffff)        # $sp = ends

        . $fp = $sp + (%s)stack00       # $fp = $sp + sizeof stack00


        . $t9[(%o)Ccnt] = $0            # reset clock counter I/O
        . $t9[(%o)RWcnt] = $0           # reset access counter I/O

        . call main                     # main()
        . nop                           # slot

        # Execution end
        . $t7 = (%w)$t9[(%o)Ccnt]       # get clock count,
        . $t8 = (%w)$t9[(%o)RWcnt]      # get access count,
        . $gp[(%o)TIME] = $t7           # 
        . $gp[(%o)ACCESS] = $t8         # and store them

        . $t0 = 0xeeee                  #
        . $gp[(%o)END] = $t0            # *END = 0x00001234

inf:    . goto inf                      # infinite loop
        . nop                           # slot

main:
        # Callee Routine (head)
        . $sp -= (%s)stack00
        . $sp[0x0c] = $ra               # return address
        . $sp[0x08] = $fp               # frame pointer
        . $fp = $sp + (%s)stack00

        . $a0 = (%w)$gp[(%o)N]          # 
        . call fact                     # call fact(N)
        . nop                           # slot
        . $gp[(%o)FACTN] = $v0          # *FACTN = fact(N)

        # Callee Routine (tail)
        . $ra = (%w)$sp[0x0c]           # return address
        . $fp = (%w)$sp[0x08]           # frame pointer
        . $sp += (%s)stack00            # pop stack frame
        . return
        . nop                           # slot

fact:
        # Callee Routine (head)
        . $sp -= (%s)stack00            # push stack frame
        . $sp[0x0c] = $ra               # return address
        . $sp[0x08] = $fp               # frame pointer
        . $fp = $sp + (%s)stack00

        . $fp[0] = $a0                  # save argument
        . $t0 = $a0 > 1                 #
        bnez $t0, @RECURSION            # if ($a0 > 1) goto L2
        . nop                           # slot
        . $v0 = 1                       # v0 = 1 (fact(1) = 1)
        . goto @TAIL
        . nop                           # slot
@RECURSION:
        . $a0 = (%w)$fp[0]
        . nop                           # load delay slot
        . --$a0                         #
        . call fact                     # fact(N - 1)
        . nop                           # slot
        . $v1 = (%w)$fp[0]              # $v1 = N
        . nop                           # load delay slot
        . $v0 *= $v1                    # $v0 = fact(N - 1) * N
@TAIL:
        . $fp[0x04] = $v0               # save return value

        # Callee Routine (tail)
        . $ra = (%w)$sp[0x0c]           # return address
        . $fp = (%w)$sp[0x08]           # frame address
        . $sp += (%s)stack00            # pop stack frame
        . return
        . nop                           # slot

        #--- data ---
        .data user + 0x2200 = "/USR/M00"[0x2200]
DATA:   .space  0                       # DATA <- start address
N:      .word  10                       # the initial argument for fact()
FACTN:  .space  4                       # 10! (0x0037f500) will be stored
END:    .space  4                       # to be 0x0000eeee at the end
TIME:   .space  4                       # clock count
ACCESS: .space  4                       # ACCESS count

        #--- stack ---
        .data user + 0xff00 = "/USR/M00"[0xff00]
stack10:.space 16
stack09:.space 16
stack08:.space 16
stack07:.space 16
stack06:.space 16
stack05:.space 16
stack04:.space 16
stack03:.space 16
stack02:.space 16
stack01:.space 16
stack00:.space 16                       # These are stack frames
ends:   .space 0
#--- End of User Program ---
