/******************************************
* (C)Copyright by N.T.T 1993(unpublished) *
* All rights are reserved.                *
******************************************/

#include <stdio.h>

main(argc, argv)
int	argc;
char	*argv[];
{
    int     adrs;
    int     data;
    int     c, d;
    int     gate;

    if (argc != 3) {
        printf("usage:\n");
        printf("        ram_pcd <address_size> <data_size>\n");
        exit(1);
    }
    adrs = atoi(*++argv);
    data = atoi(*++argv);
    for (c = adrs, d = 1; c > 0; c--, d *= 2) ;
    gate = d * data * 1.6;
    printf("(def-module r%d_%d power %d area %d gates %d\n", d, data, 2 * gate, gate, gate);
    for (c = 0; c < adrs; c++) {
        printf("\t(def-pin adrs[%d] type input load 0.05)\n", c);
    }
    for (c = 0; c < data; c++) {
        printf("\t(def-pin din[%d] type input load 0.05)\n", c);
    }
    for (c = 0; c < data; c++) {
        printf("\t(def-pin dout[%d] type output load 0.05)\n", c);
    }
    printf("\t(def-pin read type input load 0.05)\n");
    printf("\t(def-pin write type input load 0.05)\n");
    printf("\t(def-pin m_clock type input load 0.05 note clock)\n");
    printf("\t(def-pin s_clock type unused)\n");
    printf("\t(def-pin b_clock type unused)\n");
    printf("\t(def-pin p_reset type unused)\n");
    for (c = 0; c < adrs; c++) {
        for (d = 0; d < data; d++) {
            printf("\t(def-delay /adrs[%d] /dout[%d] (+ 10 (* 5 ~dout[%d])))\n", c, d, d);
        }
    }
    for (d = 0; d < data; d++) {
        printf("\t(def-delay /read /dout[%d] (+ 10 (* 5 ~dout[%d])))\n", d, d);
    }
    printf(")\n");
}

