/* /home/nagami/src/master/dlx/PCIb.h,v
** nagami
** 
** 1996/08/15 17:59:45
** 1.1
** Exp */
declare PCIb {
/**********************************++**********************************/
/*  Access Interface                                                  */
/**********************************++**********************************/
    /* Control signals */
    instrout Ready;
    instrout Reset;
    instrout BusError;

    /* Data access signals */
    bidirect Adr<32>;
    bidirect Be<4>;
    bidirect Data<32>;
    instrin ReadMem;
    instrin ReadMemLine;
    instrin WriteMem;
    instrin ReadIO;
    instrin WriteIO;
    instrin ReadConfig;
    instrin WriteConfig;
    instrout ReadDone;
    instrout WriteDone;
    instrout AccessError;

    instrout ReadMemReq;
    instrout ReadMemLineReq;
    instrout WriteMemReq;
    instrout ReadIOReq;
    instrout WriteIOReq;
    instrout ReadConfigReq;
    instrout WriteConfigReq;
    instrin ReadReqDone;
    instrin WriteReqDone;
    instrin ReqError;
    
/**********************************++**********************************/
/*  PCI interface                                                     */
/**********************************++**********************************/
    /* System pins */
    input nRST;

    /* Address and data pins */
    bidirect AD<32>; instrout ADenb;
    bidirect nC_BE<4>; instrout C_BEenb;
    bidirect PAR; instrout PARenb;

    /* Interface control pins */
    input nFRAMEin; output nFRAMEout; instrout FRAMEenb;
    input nIRDYin; output nIRDYout; instrout IRDYenb;
    input nTRDYin; output nTRDYout; instrout TRDYenb;
    input nSTOPin; output nSTOPout; instrout STOPenb;
    instrin IDSEL;
    input nDEVSELin; output nDEVSELout; instrout DEVSELenb;
    output nREQ;
    input nGNT;
    input nPERRin; output nPERRout; instrout PERRenb;
    instrout SERRenb;

/**********************************++**********************************/
/*  Instruct Arguments                                                */
/**********************************++**********************************/
    instr_arg ReadMem    (Adr, Be);
    instr_arg ReadMemLine(Adr, Be);
    instr_arg WriteMem   (Adr, Be, Data);
    instr_arg ReadIO     (Adr, Be);
    instr_arg WriteIO    (Adr, Be, Data);
    instr_arg ReadConfig (Adr, Be);
    instr_arg WriteConfig(Adr, Be, Data);

    instr_arg ReadReqDone(Data);
    instr_arg WriteReqDone();
    instr_arg ReqError();

    instr_arg IDSEL();
    /* In your `PCI' module, you should declare these instr_arg's. */
    /*
    instr_arg Ready();
    instr_arg Reset();
    instr_arg BusError();
    instr_arg ReadDone(Data);
    instr_arg WriteDone();
    instr_arg AccessError();

    instr_arg ReadMemReq    (Adr, Be);
    instr_arg ReadMemLineReq(Adr, Be);
    instr_arg WriteMemReq   (Adr, Be, Data);
    instr_arg ReadIOReq     (Adr, Be);
    instr_arg WriteIOReq    (Adr, Be, Data);
    instr_arg ReadConfigReq (Adr, Be);
    instr_arg WriteConfigReq(Adr, Be, Data);

    instr_arg ADenb(AD);
    instr_arg C_BEenb(nC_BE);
    instr_arg PARenb(PAR);
    instr_arg FRAMEenb(nFRAMEout);
    instr_arg IRDYenb(nIRDYout);
    instr_arg TRDYenb(nTRDYout);
    instr_arg STOPenb(nSTOPout);
    instr_arg DEVSELenb(nDEVSELout);
    instr_arg PERRenb(nPERRout);
    instr_arg SERRenb();
     */
}
